% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%diff\%}
\alias{\%diff\%}
\title{Numerical and Symbolic Difference}
\usage{
x \%diff\% y
}
\arguments{
\item{x}{character or numeric array.}

\item{y}{character or numeric array.}
}
\value{
character or numeric array.
}
\description{
Substracts numeric or character arrays element by element.
}
\examples{
# diff vector 
x <- c("a+1","b+2")
x \%diff\% x

# diff matrix 
x <- matrix(letters[1:4], ncol = 2)
x \%diff\% x

# diff array
x <- array(letters[1:12], dim = c(2,2,3))
y <- array(1:12, dim = c(2,2,3))
x \%diff\% x
y \%diff\% y
x \%diff\% y

}
