% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{laplacian}
\alias{laplacian}
\alias{\%laplacian\%}
\title{Numerical and Symbolic Laplacian}
\usage{
laplacian(f, var, accuracy = 2, stepsize = NULL,
  coordinates = "cartesian")

f \%laplacian\% var
}
\arguments{
\item{f}{function, expression or character array.}

\item{var}{character vector, giving the variable names with respect to which derivatives will be computed. If a named vector is provided, derivatives will be computed at that point.}

\item{accuracy}{accuracy degree for numerical derivatives.}

\item{stepsize}{finite differences stepsize for numerical derivatives. Auto-optimized by default.}

\item{coordinates}{coordinate system to use. One of: \code{cartesian}, \code{polar}, \code{spherical}, \code{cylindrical}, \code{parabolic}, \code{parabolic-cylindrical} or a character vector of scale factors for each varibale.}
}
\value{
laplacian array.
}
\description{
Computes the laplacian of functions, expressions and characters.
}
\section{Functions}{
\itemize{
\item \code{laplacian}: arbitrary coordinate system

\item \code{\%laplacian\%}: cartesian coordinates
}}

\examples{
# laplacian of a scalar field
f <- 'x^2+y^2+z^2'
laplacian(f, var = c('x','y','z'))
f \%laplacian\% c('x','y','z')

# laplacian of scalar fields
f <- c('x^2','y^3','z^4')
laplacian(f, var = c('x','y','z'))
f \%laplacian\% c('x','y','z')

# numerical laplacian of scalar fields
f <- c(function(x,y,z) x^2, function(x,y,z) y^3, function(x,y,z) z^4)
laplacian(f, var = c('x'=1,'y'=1,'z'=1))
f \%laplacian\% c('x'=1,'y'=1,'z'=1)

# laplacian of array of scalar fields
f1 <- c('x^2','y^3','z^4')
f2 <- c('x','y','z')
a <- matrix(c(f1,f2), nrow = 2, byrow = TRUE)
laplacian(a, var = c('x','y','z'))
a \%laplacian\% c('x','y','z')

# laplacian in polar coordinates
f <- c('sqrt(r)/10','sqrt(r)')
laplacian(f, var = c('r','phi'), coordinates = 'polar')

}
