% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrease_pop.R
\name{decrease_pop}
\alias{decrease_pop}
\title{Decreasing of the population of parameters sets}
\usage{
decrease_pop(matobj, minmax, prec, archsize, popsize)
}
\arguments{
\item{matobj}{: matrix of objectives, dimension (ngames, nobj)}

\item{minmax}{: vector of booleans, of dimension nobj: TRUE if maximization of the objective, FALSE otherwise}

\item{prec}{: nobj dimension vector: accuracy}

\item{archsize}{: integer: archive size}

\item{popsize}{: integer: population size}
}
\value{
A list containing two elements:
\describe{
\item{ind_arch}{indices of individuals in the updated Pareto front}
\item{ind_pop}{indices of individuals in the updated population} 
}
}
\description{
decreases the population of parameters sets
}
\examples{
# Definition of the parameters
matobj <- matrix(rexp(200), 100, 2)
prec <- c(1.e-3, 1.e-3)
archsize <- 100
minmax <- c(FALSE, FALSE)
popsize <- 100
# Call the function
res <- decrease_pop(matobj, minmax, prec, archsize, popsize)

}
\author{
Fabrice Zaoui
}
