% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_test_MGD.R
\name{getRelevantParameters}
\alias{getRelevantParameters}
\title{Internal: Extract relevant parameters from several cSEMResults_multi}
\usage{
getRelevantParameters(
  .object     = args_default()$.object,
  .model      = args_default()$.model
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax} indicating which
parameters (i.e., path (\code{~}), loadings (\verb{=~}), or weights (\verb{<~})) should be
compared across groups. Defaults to \code{NULL} in which case all parameters of the model
are compared.}
}
\value{
A list of length equal to the number of groups in \code{.object}.
Each list element is itself a list of three. The first list element contains
the relevant parameter estimates of the structural model, the second
list element the relevant estimated loadings, and the third
the relevant estimated weights.
}
\description{
Extract the relevant parameters from a cSEMResult_multi object in \code{.object}.
}
\keyword{internal}
