% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{threecommonfactors}
\alias{threecommonfactors}
\title{Data: threecommonfactors}
\format{
A matrix with 500 rows and 9 variables:
\describe{
\item{y11-y13}{Indicators attachted to the first common factor (\code{eta1}).
Population loadings are: 0.7; 0.7; 0.7}
\item{y21-y23}{Indicators attachted to the second common factor (\code{eta2}).
Population loadings are: 0.5; 0.7; 0.8}
\item{y31-y33}{Indicators attachted to the third common factor (\code{eta3}).
Population loadings are: 0.8; 0.75; 0.7}
}

The model is:
\deqn{`eta2` = gamma1 * `eta1` + zeta1}
\deqn{`eta3` = gamma2 * `eta1` + beta * `eta2` + zeta2}

with population values \code{gamma1} = 0.6, \code{gamma2} = 0.4 and \code{beta} = 0.35.
}
\usage{
threecommonfactors
}
\description{
A dataset containing 500 standardized observations on 9 indicator generated from a
population model with three concepts modeled as common factors.
}
\examples{
#============================================================================
# Correct model (the model used to generate the data)
#============================================================================
model_correct <- "
# Structural model
eta2 ~ eta1
eta3 ~ eta1 + eta2

# Measurement model
eta1 =~ y11 + y12 + y13
eta2 =~ y21 + y22 + y23
eta3 =~ y31 + y32 + y33 
"

a <- csem(threecommonfactors, model_correct)

## The overall model fit is evidently almost perfect:
testOMF(a, .R = 30, .verbose = FALSE) # .R = 30 to speed up the example
}
\keyword{datasets}
