% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{rankBySlidingWindow}
\alias{rankBySlidingWindow}
\title{Determine the norm scores of the participants by sliding window (experimental)}
\usage{
rankBySlidingWindow(
  data = NULL,
  age = "age",
  raw = "raw",
  weights = NULL,
  width,
  method = 4,
  scale = "T",
  descend = FALSE,
  descriptives = TRUE,
  nGroup = 0,
  group = NA,
  covariate = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data}{data.frame with norm sample data}

\item{age}{the continuous age variable. Setting 'age' to FALSE inhibits computation of
powers of age and the interactions}

\item{raw}{name of the raw value variable (default 'raw')}

\item{weights}{Vector or variable name in the dataset with weights for each individual case. It can be used
to compensate for moderate imbalances due to insufficient norm data stratification. Weights should be numerical
and positive.
Please note, that this feature is currently EXPERIMENTAL and subject to ongoing work! Precision of weighting increases
with sample size. On the other hand, in large samples, it is easy to stratificate and then weighting is not needed anymore.}

\item{width}{the width of the sliding window}

\item{method}{Ranking method in case of bindings, please provide an index,
choosing from the following methods: 1 = Blom (1958), 2 = Tukey (1949),
3 = Van der Warden (1952), 4 = Rankit (default), 5 = Levenbach (1953),
6 = Filliben (1975), 7 = Yu & Huang (2001)}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index points}

\item{descend}{ranking order (default descent = FALSE): inverses the
ranking order with higher raw scores getting lower norm scores; relevant
for example when norming error scores, where lower scores mean higher
performance}

\item{descriptives}{If set to TRUE (default), information in n, mean, median and
standard deviation per group is added to each observation}

\item{nGroup}{If set to a positive value, a grouping variable is created with the desired number of
equi distant groups, named by the group mean age of each group. It creates the
column 'group' in the data.frame and in case, there is already one with that name,
overwrites it.}

\item{group}{Optional parameter for providing the name of the grouping variable (if present; overwritten
if ngroups is used)}

\item{covariate}{Include a binary covariate into the preparation and subsequently modeling,
either by specifying the variable name or including the variable itself. BEWARE!
Not all subsequent functions are already prepared for it.  It is an experimental feature.}

\item{na.rm}{remove values, where the percentiles could not be estimated,
most likely happens in the context of weighting}
}
\value{
the dataset with the individual percentiles and norm scores
}
\description{
The function retrieves all individuals in the predefined age range (x +/- width/2)
around each case and ranks that individual based on this individually drawn sample.
This function can be directly used with a continuous age variable in order to avoid
grouping. When collecting data on the basis of a continuous age variable, cases
located far from the mean age of the group receive distorted percentiles when building
discrete groups and generating percentiles with the traditional approach. The distortion
increases with distance from the group mean and this effect can be avoided by the
sliding window. Nonetheless, please ensure, that the optional grouping variable in fact
represents the correct mean age of the respective age groups, as this variable is
later on used for displaying the manifest data in the percentile plots.
}
\details{
In case of bindings, the function uses the medium rank and applies the algorithms
already described in the \code{\link{rankByGroup}} function. At the upper and lower end of the
data sample, the sliding stops and the sample is drawn from the interval min + width and
max - width, respectively.
}
\section{Remarks on using covariates}{

So far the inclusion of a binary covariate is experimental and far from optimized.
The according variable name has to be specified in the ranking procedure
and the modeling includes this in the further process. At the moment, during ranking
the data are split into the according degrees of the covariate and the ranking is done
separately. This may lead to small sample sizes. Please take care to have enough cases in each combination. Additionally,
covariates can lead to unstable modeling solutions. The question, if it is really
reasonable to include covariates when norming a test is a decision beyond the pure data
modeling. Please use with care or alternatively split the dataset into the two groups
beforehand and model them separately.
}

\examples{
\dontrun{
# Transformation using a sliding window
data.elfe2 <- rankBySlidingWindow(relfe, raw = "raw", age = "group", width = 0.5)

# Comparing this to the traditional approach should give us exactly the same
# values, since the sample dataset only has a grouping variable for age
data.elfe <- rankByGroup(elfe, group = "group")
mean(data.elfe$normValue - data.elfe2$normValue)
}
}
\seealso{
rankByGroup, computePowers

Other prepare: 
\code{\link{computePowers}()},
\code{\link{prepareData}()},
\code{\link{rankByGroup}()}
}
\concept{prepare}
