% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{simulateRasch}
\alias{simulateRasch}
\title{Simulate raw test scores based on Rasch model}
\usage{
simulateRasch(
  data = NULL,
  n = 100,
  minAge = 1,
  maxAge = 7,
  items.n = 21,
  items.m = 0,
  items.sd = 1,
  Theta = "random",
  width = 1
)
}
\arguments{
\item{data}{data.frame from previous simulations for recomputation (overrides n, minAge, maxAge)}

\item{n}{The sample size per age group}

\item{minAge}{The minimum age (default 1)}

\item{maxAge}{The maximum age (default 7)}

\item{items.n}{The number of items of the test}

\item{items.m}{The mean difficulty of the items}

\item{items.sd}{The standard deviation of the item difficulty}

\item{Theta}{irt scales difficulty parameters, either "random" for drawing a random sample,
"even" for evenly distributed or a set of predefined values, which then overrides the item.n
parameters}

\item{width}{The width of the window size for the continuous age per group; +- 1/2 width around group
center
on items.m and item.sd; if set to FALSE, the distribution is not drawn randomly but normally nonetheless}
}
\value{
a list containing the simulated data and thetas
\describe{
  \item{data}{the data.frame with only age, group and raw}
  \item{sim}{the complete simulated data with item level results}
  \item{theta}{the difficulty of the items}
}
}
\description{
For testing purposes only:
The function simulates raw test scores based on a virtual Rasch based test with n results per
age group, an evenly distributed age variable, items.n test items with a simulated difficulty and
standard deviation. The development trajectories over age group are modeled by a curve linear
function of age, with at first fast progression, which slows down over age, and a slightly increasing
standard deviation in order to model a scissor effects. The item difficulties can be accessed via $theta
and the raw data via $data of the returned object.
}
\examples{
# simulate data for a rather easy test (m = -1.0)
sim <- simulateRasch(n=150, minAge=1,
                     maxAge=7, items.n = 30, items.m = -1.0,
                     items.sd = 1, Theta = "random", width = 1.0)

# Show item difficulties
mean(sim$theta)
sd(sim$theta)
hist(sim$theta)

# Plot raw scores
boxplot(raw~group, data=sim$data)

# Model data
data <- prepareData(sim$data, age="age")
model <- bestModel(data, k = 4)
printSubset(model)
plotSubset(model, type=0)
}
