% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{getNormCurve}
\alias{getNormCurve}
\title{Computes the curve for a specific T value}
\usage{
getNormCurve(
  norm,
  model,
  minAge = NULL,
  maxAge = NULL,
  step = 0.1,
  minRaw = NULL,
  maxRaw = NULL,
  covariate = NULL
)
}
\arguments{
\item{norm}{The specific norm score, e. g. T value}

\item{model}{The model from the regression modeling}

\item{minAge}{Age to start from}

\item{maxAge}{Age to stop at}

\item{step}{Stepping parameter for the precision when retrieving of the values, lower
values indicate higher precision (default 0.1).}

\item{minRaw}{lower bound of the range of raw scores (default = 0)}

\item{maxRaw}{upper bound of raw scores}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate or
the specific value here.}
}
\value{
data.frame of the variables raw, age and norm
}
\description{
As with this continuous norming regression approach, raw scores are modeled as a function of age and norm score
(location), getNormCurve is a straightforward approach to show the raw score development over
age, while keeping the norm value constant. This way, e. g. academic performance or intelligence development
of a specific ability is shown.
}
\examples{
normData <- prepareData()
m <- bestModel(data = normData)
getNormCurve(35, m)
}
