% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bzip.R
\name{bzip.b}
\alias{bzip.b}
\alias{lik.bzip.b}
\alias{rbzip.b}
\title{The bivariate zero-inflated Poisson distribution (B)}
\usage{
lik.bzip.b(xvec, yvec, m0, m1, m2, p1, p2, p3, p4, param = NULL)

rbzip.b(n, m0, m1, m2, p1, p2, p3, p4, param = NULL)

bzip.b(
  xvec,
  yvec,
  tol = 1e-06,
  initial = NULL,
  showFlag = FALSE,
  maxiter = 200
)
}
\arguments{
\item{xvec, yvec}{a pair of BZIP (B) random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{m0, m1, m2}{mean parameters of the Poisson variables. must be positive.}

\item{p1, p2, p3, p4}{proportions summing up to 1 (\code{p1 + p2 + p3 + p4 = 1}). 
\code{p1} is the probability of both latent Poisson variables being observed. 
\code{p2} is the probability of only the first Poisson variables being observed.
\code{p3} is the probability of only the second Poisson variables being observed, and
\code{p4} is the probability of both Poisson variables being dropped out.}

\item{param}{a vector of parameters (\code{(m0, m1, m2, p1, p2, p3, p4)}). 
Either \code{param} or individual parameters (\code{m0, m1, m2, p1, p2, p3, p4}) 
need to be provided.}

\item{n}{number of observations.}

\item{tol}{tolerance for judging convergence. \code{tol = 1e-8} by default.}

\item{initial}{starting value of param for EM algorithm, a vector of nine values.}

\item{showFlag}{if \code{TRUE}, the updated parameter estimates for each iteration 
are printed out. If a positive integer, the updated parameter estimates for 
iterations greater than \code{showFlag} are printed out.}

\item{maxiter}{maximum number of iterations allowed. \code{tol = 50000} by default.}
}
\value{
\itemize{
   \item \code{rbzip.b} gives a pair of random vectors following BZIP (B) distribution.
   \item \code{bzip.b} gives the maximum likelihood estimates of a BZIP (B) pair.
   \item \code{lik.bzip.b} gives the log-likelihood of a set of parameters for a BZIP (B) pair.

 }
}
\description{
random generation (\code{rbzip.b}), maximum likelihood estimation (\code{bzip.b}), 
   and log-likelihood. (\code{lik.bzip.b})  for the bivariate zero-inflated Poisson (B)
   distribution with parameters equal to \code{(m0, m1, m2, p1, p2, p3, p4)}.
}
\examples{
# generating a pair of random vectors
set.seed(1)
data1 <- rbzip.b(n = 20, m0 = 1, m1 = 1, m2 = 1, 
                p1 = 0.5, p2 = 0.2, p3 = 0.2, p4 = 0.1)

lik.bzip.b(xvec = data1[, 1], yvec = data1[ ,2], 
          m0 = 1, m1 = 1, m2 = 1, 
          p1 = 0.5, p2 = 0.2, p3 = 0.2, p4 = 0.1)

bzip.b(xvec = data1[,1], yvec = data1[,2], showFlag = FALSE)

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
