% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bzip.R
\name{bzip.a}
\alias{bzip.a}
\alias{lik.bzip.a}
\alias{rbzip.a}
\title{The bivariate zero-inflated Poisson distribution (A)}
\usage{
lik.bzip.a(xvec, yvec, m0, m1, m2, p, param = NULL)

rbzip.a(n, m0, m1, m2, p, param = NULL)

bzip.a(xvec, yvec, tol = 1e-06, initial = NULL, showFlag = FALSE)
}
\arguments{
\item{xvec, yvec}{a pair of BZIP (A) random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{m0, m1, m2}{mean parameters of the Poisson variables. must be positive.}

\item{p}{zero-inflation probability}

\item{param}{a vector of parameters (\code{(m0, m1, m2, p)}). 
Either \code{param} or individual parameters (\code{m0, m1, m2, p}) 
need to be provided.}

\item{n}{number of observations.}

\item{tol}{tolerance for judging convergence. \code{tol = 1e-8} by default.}

\item{initial}{starting value of param for EM algorithm, a vector of nine values.}

\item{showFlag}{if \code{TRUE}, the updated parameter estimates for each iteration 
are printed out. If a positive integer, the updated parameter estimates for 
iterations greater than \code{showFlag} are printed out.}
}
\value{
\itemize{
   \item \code{rbzip.a} gives a pair of random vectors following BZIP (A) distribution.
   \item \code{bzip.a} gives the maximum likelihood estimates of a BZIP (A) pair.
   \item \code{lik.bzip.a} gives the log-likelihood of a set of parameters for a BZIP (A) pair.

 }
}
\description{
random generation (\code{rbzip.a}), maximum likelihood estimation (\code{bzip.a}), 
   and log-likelihood. (\code{lik.bzip.a})  for the bivariate zero-inflated Poisson (A)
   distribution with parameters equal to \code{(m0, m1, m2, p)}.
}
\examples{
# generating a pair of random vectors
set.seed(1)
data1 <- rbzip.a(n = 20, m0 = 1, m1 = 1, m2 = 1, p = 0.5)

lik.bzip.a(xvec = data1[, 1], yvec = data1[ ,2], 
          m0 = 1, m1 = 1, m2 = 1, p = 0.5)

bzip.a(xvec = data1[,1], yvec = data1[,2], showFlag = FALSE)

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"

 Li, C. S., Lu, J. C., Park, J., Kim, K., Brinkley, P. A., & Peterson, J. P. (1999). 
 Multivariate zero-inflated Poisson models and their applications. Technometrics, 41, 29-38.
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
