% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_b.R
\name{get_b}
\alias{get_b}
\title{Get Analytical Estimate for Utility Coefficient from Raw Count Vectors}
\usage{
get_b(data, totals, bests, worsts, z = 1.96)
}
\arguments{
\item{data}{A data.frame where each row represents an item, and three columns
represent total times shown to participants, total times selected as bests,
and total time selected as worsts}

\item{totals}{A string that is the name of the column for totals in the data}

\item{bests}{A string that is the name of the column for bests in the data}

\item{worsts}{A string that is the name of the column for worsts in the data}

\item{z}{A z-value to calculate the confidence intervals. Defaults to 1.96,
a 95\% CI}
}
\value{
A data frame containing the utility coefficients, standard errors,
  and upper and lower confidence intervals for each item (row) in the data
}
\description{
This is a simple wrapper for get_b0, and it will compute utility
  coefficients, standard errors, and confidence intervals for multiple
  items in a best-worst scaling design.
}
