% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bvar.R, R/print.summary.bvar.R
\name{summary.bvar}
\alias{summary.bvar}
\alias{print.summary.bvar}
\title{Summarising Bayesian VAR Coefficients}
\usage{
\method{summary}{bvar}(object, ci = 0.95, ...)

\method{print}{summary.bvar}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of class \code{"bvar"}, usually, a result of a call to
\code{\link{bvar}} or \code{\link{bvec_to_bvar}}.}

\item{ci}{a numeric between 0 and 1 specifying the probability of the credible band.
Defaults to 0.95.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.bvar"}, usually, a result of a call to
\code{\link{summary.bvar}}.}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
\code{summary.bvar} returns a list of class \code{"summary.bvar"},
which contains the following components:
\item{coefficients}{A list of various summary statistics of the posterior
draws of the VAR coefficients.}
\item{sigma}{A list of various summary statistics of the posterior
draws of the variance-covariance matrix.}
\item{specifications}{a list containing information on the model specification.}
}
\description{
summary method for class \code{"bvar"}.
}
