% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{post_normal_sur}
\alias{post_normal_sur}
\title{Posterior Draw from a Normal Distribution}
\usage{
post_normal_sur(y, z, sigma_i, a_prior, v_i_prior, svd = FALSE)
}
\arguments{
\item{y}{a \eqn{K \times T} matrix of endogenous variables.}

\item{z}{a \eqn{KT \times M} matrix of explanatory variables.}

\item{sigma_i}{the inverse of the constant \eqn{K \times K} error variance-covariance matrix.
For time varying variance-covariance matrics a \eqn{KT \times K} can be provided.}

\item{a_prior}{a \eqn{M x 1} numeric vector of prior means.}

\item{v_i_prior}{the inverse of the \eqn{M x M} prior covariance matrix.}

\item{svd}{logical. If \code{TRUE} the singular value decomposition is used to determine
the root of the posterior covariance matrix. Default is \code{FALSE} which means
that the eigenvalue decomposition is used.}
}
\value{
A vector.
}
\description{
Produces a draw of coefficients from a normal posterior density for
a model with seemingly unrelated regresssions (SUR).
}
\details{
The function produces a posterior draw of the coefficient vector \eqn{a} for the model
\deqn{y_{t} = Z_{t} a + u_{t},}
where \eqn{u_t \sim N(0, \Sigma_{t})}.
\eqn{y_t} is a K-dimensional vector of endogenous variables and
\eqn{Z_t = z_t^{\prime} \otimes I_K} is a \eqn{K \times KM} matrix of regressors with
\eqn{z_t} as a vector of regressors.

For a given prior mean vector \eqn{\underline{a}} and prior covariance matrix \eqn{\underline{V}}
the posterior covariance matrix is obtained by
\deqn{\overline{V} = \left[ \underline{V}^{-1} + \sum_{t=1}^{T} Z_{t}^{\prime} \Sigma_{t}^{-1} Z_{t} \right]^{-1}}
and the posterior mean by
\deqn{\overline{a} = \overline{V} \left[ \underline{V}^{-1} \underline{a} + \sum_{t=1}^{T} Z_{t}^{\prime} \Sigma_{t}^{-1} y_{t}  \right].}
}
\examples{
# Prepare data
data("e1")
data <- diff(log(e1))
temp <- gen_var(data, p = 2, deterministic = "const")
y <- temp$Y
x <- temp$Z
k <- nrow(y)
z <- kronecker(t(x), diag(1, k))
t <- ncol(y)
m <- k * nrow(x)

# Priors
a_mu_prior <- matrix(0, m)
a_v_i_prior <- diag(0.1, m)

# Initial value of inverse Sigma
sigma_i <- solve(tcrossprod(y) / t)

# Draw parameters
a <- post_normal_sur(y = y, z = z, sigma_i = sigma_i,
                     a_prior = a_mu_prior, v_i_prior = a_v_i_prior)

}
