% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{series_stats}
\alias{series_stats}
\title{Generate series-level descriptive statistics.}
\usage{
series_stats(x, func_list = list(first = first_year, last = last_year,
  years = count_year_span, inner_type = inner_type, outer_type =
  outer_type, number_scars = count_scar, number_injuries = count_injury,
  recording_years = count_recording, mean_interval = series_mean_interval))
}
\arguments{
\item{x}{An fhx object.}

\item{func_list}{A list of named functions that will be run on each series
in the fhx object. The list name for each function is the corresponding
column name in the output data.frame.}
}
\value{
A data.frame containing series-level statistics.
}
\description{
Generate series-level descriptive statistics.
}
\examples{
data(lgr2)
series_stats(lgr2)

# You can create your own list of statistics to output. You can also create
# your own functions:
flist <- list(n = count_year_span,
              xbar_interval = function(x) mean_interval(x, injury_event = TRUE))
sstats <- series_stats(lgr2)
head(sstats)

}
