% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_smard.R
\name{smard_timeseries}
\alias{smard_timeseries}
\title{Fetch SMARD timeseries data}
\usage{
smard_timeseries(
  filter,
  region = "DE",
  resolution = "hour",
  timestamp,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{filter}{Filter id.}

\item{region}{Region code.}

\item{resolution}{Data resolution.}

\item{timestamp}{Timestamp from indices (ms), POSIXct, or Date.

Timestamps are interpreted in the Europe/Berlin timezone.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble of time series values.

Includes a \code{time} column with POSIXct timestamps in Europe/Berlin.
}
\description{
Fetch SMARD timeseries data
}
\details{
Returns a tidy time series for a single filter/region. Use
\code{\link[=smard_indices]{smard_indices()}} to obtain a valid timestamp. Official docs:
https://smard.api.bund.dev.
}
\examples{
\dontrun{
indices <- smard_indices(410, region = "DE", resolution = "hour")
smard_timeseries(410, region = "DE", resolution = "hour", timestamp = indices$timestamp[[1]])
}

}
\seealso{
\code{\link[=smard_indices]{smard_indices()}} for timestamps and \code{\link[=smard_table]{smard_table()}} for table output.
}
