% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_webcam_details}
\alias{autobahn_webcam_details}
\title{Get Autobahn webcam details}
\usage{
autobahn_webcam_details(webcam_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{webcam_id}{Webcam identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with webcam details.
}
\description{
Get Autobahn webcam details
}
\details{
Returns full details for a single webcam entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
webcams <- autobahn_webcams(roads$road_id[[1]])
autobahn_webcam_details(webcams$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_webcams]{autobahn_webcams()}} to list webcams.
}
