#LTP: likelihood, tree probabiity, posterior
compLTP_binary=function(ET,base,power){

  ###################################################
  ###1. log likelihood
  ###################################################
  loglik=0
  bhat=list()
  yhat=NA #yhat
  for(j in ET$terminal){
    wh.j=which(ET$node.hat==j) #idx for subgroup j
    y.j=ET$y[wh.j] #y for subgroup j
    z.j=ET$z[wh.j,ET$marker[j]] #selected marker for subgroup j
    depth.j=floor(log2(j))+1

    #bayesian logistic wt prior: biv indep normal
    ssglm.j=arm::bayesglm(y.j~z.j,family=binomial,
                          # prior.mean = 0,
                          # prior.scale = Inf, #/sqrt(depth.j),
                          prior.df = Inf, #normal prior for beta1
                          # prior.mean.for.intercept = 0,
                          # prior.scale.for.intercept = Inf, #/sqrt(depth.j),
                          prior.df.for.intercept = Inf, #normal prior for beta0
                          scaled=FALSE)

    #compute predictive posterior (Laplace approximation)
    mu = summary(ssglm.j)$coefficients[1,1]+summary(ssglm.j)$coefficients[2,1]*z.j
    H = vcov(ssglm.j)
    sigma2 = NA
    for(ii in 1:length(y.j)){
      sigma2[ii] = matrix(c(1,z.j[ii]), ncol = 2) %*% H %*% t(matrix(c(1,z.j[ii]), ncol = 2))
    }
    p.ii=pnorm(mu/sqrt(8/pi+sigma2)) #Probit approximation
    loglik = loglik + sum(log(c(p.ii[y.j==1],(1-p.ii[y.j==0]))))
    # loglik = loglik + sum(log(p.ii^y.j[ii]*(1-p.ii)^(1-y.j[ii])))
    bhat[[j]]=ssglm.j$coefficients
    yhat[wh.j]=ssglm.j$fitted.values
  }
  ET$bhat=bhat
  ET$loglik=loglik
  ET$yhat=yhat

  ###################################################
  ##2 log tree prob
  ###################################################
  logTreeProb=0
  n.terminal=ET$terminal
  for(m in ET$terminal){ #each terminal node
    depth=floor(log2(m))
    logTreeProb = logTreeProb+log(1-prior.tree(base,power,depth))+log(ET$dir.marker[ET$marker[m]])
                              #1-splitting prob                  # marker sel prob
  }

  if(ET$numNodes>1){ #each internal node
    for(m in ET$internal){
      depth=floor(log2(m))
      logTreeProb=logTreeProb+log(prior.tree(base,power,depth))+log(ET$dir.predictor[ET$splitVariable[m]])+log(ET$eta[m])
                              #splitting prob                   # feature sel prob                         #cutoff sel prob
      #eta[m] is the number of unique values for mth predction selected for the mth internal node
    }
  }
  ET$logTreeProb=logTreeProb

  ###################################################
  ###3. log posterior
  ###################################################
  ET$logPosterior=loglik+logTreeProb #proportion of posterior since noming constant is ignored.

  return(ET)
}
