% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_filter.R
\name{auxiliary_filter}
\alias{auxiliary_filter}
\alias{auxiliary_filter.nlg_ssm}
\alias{auxiliary_filter.gssm}
\alias{auxiliary_filter.bsm}
\title{Auxiliary Particle Filtering}
\usage{
auxiliary_filter(object, nsim, ...)

\method{auxiliary_filter}{nlg_ssm}(object, nsim,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{auxiliary_filter}{gssm}(object, nsim, optimal = TRUE,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{auxiliary_filter}{bsm}(object, nsim, optimal = TRUE,
  seed = sample(.Machine$integer.max, size = 1), ...)
}
\arguments{
\item{object}{of class \code{gssm}, \code{bsm}, or \code{nlg_ssm}.}

\item{nsim}{Number of samples.}

\item{...}{Ignored.}

\item{seed}{Seed for RNG.}

\item{optimal}{For Gaussian models, use optimal proposals? Default is \code{TRUE}.}
}
\value{
A list containing samples, filtered estimates and the corresponding covariances,
weights from the last time point, and an estimate of log-likelihood.
}
\description{
Function \code{auxiliary_filter} performs a auxiliary particle filtering with stratification
resampling.
}
\examples{
model <- bsm(Nile, sd_level = sqrt(1500), sd_y = sqrt(15000), a1 = 1000)
out_apf <- auxiliary_filter(model, nsim = 1000, seed = 1, optimal = FALSE)
out_oapf <- auxiliary_filter(model, nsim = 1000, seed = 1, optimal = TRUE)
ts.plot(out_apf$att, out_oapf$att, kfilter(model)$att, col = 1:3)
library("diagis")
ts.plot(cbind(apply(out_apf$weights, 2, ess), 
apply(out_oapf$weights, 2, ess)), ylim = c(0, 1000), col = 1:2)
}
