% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_attr.R
\name{bs_set_data}
\alias{bs_set_data}
\alias{bs_set_aria}
\title{Sets Bootstrap data- and aria- attributes.}
\usage{
bs_set_data(tag, ...)

bs_set_aria(tag, ...)
}
\arguments{
\item{tag}{\code{htmltools::\link[htmltools]{tag}}}

\item{...}{named arguments used to set the attributes of \code{tag}}
}
\value{
\code{htmltools::\link[htmltools]{tag}}, modified copy of \code{tag}
}
\description{
Helper function to manage attributes for Bootstrap's JavaScript components.
}
\details{
One of the mechanisms used by the API for Boostrap JavaScript-components is
an html elements' attributes. These attribute names are prefixed with
\code{"data-"} or \code{"aria-"}, depending on the function.

When expressed in html, attributes themselves have the properties:

\itemize{
  \item Logical values are expressed as \code{"true"} or \code{"false"}.
  \item Time durations are expressed as number of milliseconds.
  \item Vector (non scalar) values are expressed in a space-delimited list.
}

The purpose of this function is to let you express these values in ways
familiar to you as an R user. For example:

\itemize{
  \item Logical values can be expressed as logicals: \code{TRUE} or \code{FALSE}.
  \item Time durations can be expressed using lubridate durations.
  \item Vector (non scalar) values can be expressed as vectors.
}

Note that this returns a modified copy of the tag sent to it, so it is pipeable.
}
\examples{
library("htmltools")
library("lubridate")

tags$div() \%>\%
  bs_set_data(
    target = "#foobar",
    delay = dseconds(1),
    placement = c("right", "auto")
  ) \%>\%
  bs_set_aria(expanded = FALSE)
}
\seealso{
\href{http://getbootstrap.com/javascript}{Bootstrap JavaScript Components}
}
