% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-global.R, R/bs-theme.R
\name{bs_global_theme}
\alias{bs_global_theme}
\alias{bs_global_set}
\alias{bs_global_get}
\alias{bs_global_clear}
\alias{bs_global_add_variables}
\alias{bs_global_add_rules}
\alias{bs_global_bundle}
\alias{bs_global_theme_update}
\title{Global theming}
\usage{
bs_global_theme(
  version = version_default(),
  preset = NULL,
  bg = NULL,
  fg = NULL,
  primary = NULL,
  secondary = NULL,
  success = NULL,
  info = NULL,
  warning = NULL,
  danger = NULL,
  base_font = NULL,
  code_font = NULL,
  heading_font = NULL,
  ...,
  bootswatch = NULL
)

bs_global_set(theme = bs_theme())

bs_global_get()

bs_global_clear()

bs_global_add_variables(
  ...,
  .where = "defaults",
  .default_flag = identical(.where, "defaults")
)

bs_global_add_rules(...)

bs_global_bundle(...)

bs_global_theme_update(
  ...,
  preset = NULL,
  bg = NULL,
  fg = NULL,
  primary = NULL,
  secondary = NULL,
  success = NULL,
  info = NULL,
  warning = NULL,
  danger = NULL,
  base_font = NULL,
  code_font = NULL,
  heading_font = NULL,
  bootswatch = NULL
)
}
\arguments{
\item{version}{The major version of Bootstrap to use (see \code{\link[=versions]{versions()}}
for possible values). Defaults to the currently recommended version
for new projects (currently Bootstrap 5).}

\item{preset}{The name of a theme preset, either a built-in theme provided by
bslib or a Bootswatch theme (see \code{\link[=builtin_themes]{builtin_themes()}} and
\code{\link[=bootswatch_themes]{bootswatch_themes()}} for possible values). This argument takes precedence
over the \code{bootswatch} argument and only one \code{preset} or \code{bootswatch} can be
provided. When no \code{bootswatch} theme is specified, and \code{version} is 5 or
higher, \code{preset} defaults to \code{"shiny"}. To remove the \code{"shiny"} preset,
provide a value of \code{"bootstrap"} (this value will also work in
\code{bs_theme_update()} to remove a \code{preset} or \code{bootswatch} theme).}

\item{bg}{A color string for the background.}

\item{fg}{A color string for the foreground.}

\item{primary}{A color to be used for hyperlinks, to indicate primary/default
actions, and to show active selection state in some Bootstrap components.
Generally a bold, saturated color that contrasts with the theme's base
colors.}

\item{secondary}{A color for components and messages that don't need to stand
out. (Not supported in Bootstrap 3.)}

\item{success}{A color for messages that indicate an operation has succeeded.
Typically green.}

\item{info}{A color for messages that are informative but not critical.
Typically a shade of blue-green.}

\item{warning}{A color for warning messages. Typically yellow.}

\item{danger}{A color for errors. Typically red.}

\item{base_font}{The default typeface.}

\item{code_font}{The typeface to be used for code. Be sure this is monospace!}

\item{heading_font}{The typeface to be used for heading elements.}

\item{...}{arguments passed along to \code{\link[=bs_add_variables]{bs_add_variables()}}.}

\item{bootswatch}{The name of a bootswatch theme (see \code{\link[=bootswatch_themes]{bootswatch_themes()}}
for possible values). When provided to \code{bs_theme_update()}, any previous
Bootswatch theme is first removed before the new one is applied (use
\code{bootswatch = "bootstrap"} to effectively remove the Bootswatch theme).}

\item{theme}{A \code{\link[=bs_theme]{bs_theme()}} object.}

\item{.where}{Whether to place the variable definitions before other Sass
\code{"defaults"}, after other Sass \code{"declarations"}, or after other Sass
\code{"rules"}.}

\item{.default_flag}{Whether or not to add a \code{!default} flag (if missing) to
variable expressions. It's recommended to keep this as \code{TRUE} when \code{.where = "defaults"}.}
}
\value{
Functions that modify the global theme (e.g., \code{bs_global_set()})
invisibly return the previously set theme. \code{bs_global_get()} returns the
current global theme.
}
\description{
\code{bs_global_theme()} creates and sets the global Bootstrap Sass theme. This
theme is typically found by \code{\link[=bs_theme_dependencies]{bs_theme_dependencies()}} in the app or document
where the global theme is being used. You can obtain the current global theme
with \code{\link[=bs_global_get]{bs_global_get()}} or directly set the global theme with
\code{\link[=bs_global_set]{bs_global_set()}}.
}
\examples{
# Remember the global state now (so we can restore later)
theme <- bs_global_get()

# Use Bootstrap 3 (globally) with some theme customization
bs_global_theme(3, bg = "#444", fg = "#e4e4e4", primary = "#e39777")
if (rlang::is_interactive()) {
  bs_theme_preview(with_themer = FALSE)
}

# If no global theme is active, bs_global_get() returns NULL
bs_global_clear()
bs_global_get()

# Restore the original state
bs_global_set(theme)

}
\seealso{
Other Bootstrap theme functions: 
\code{\link{bs_add_variables}()},
\code{\link{bs_current_theme}()},
\code{\link{bs_dependency}()},
\code{\link{bs_remove}()},
\code{\link{bs_theme_dependencies}()},
\code{\link{bs_theme_preview}()},
\code{\link{bs_theme}()}
}
\concept{Bootstrap theme functions}
