% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_delete_wrappers.R
\name{bs_delete_follow}
\alias{bs_delete_follow}
\alias{bs_unfollow}
\title{Delete a follow (un-follow someone)}
\usage{
bs_delete_follow(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)

bs_unfollow(
  rkey,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{rkey}{Character, length 1. The CID of the version of the record. If not specified, then return the most recent version.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
an \code{httr2} status code
}
\description{
Delete a follow (un-follow someone)
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/follow.json}{graph/list.json (2024-12-03)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/deleteRecord.json}{repo/deleteRecord.json (2024-12-01)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-03)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
foll <- bs_follow(subject = 'chriskenny.bsky.social')
bs_delete_follow(bs_extract_record_key(foll$uri))
# obviously, you deleted this by mistake and want to follow me
foll <- bs_follow(subject = 'chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{repo}
