% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actor_search.R
\name{bs_search_actors}
\alias{bs_search_actors}
\title{Find profiles matching search criteria}
\usage{
bs_search_actors(
  query,
  typeahead = FALSE,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{query}{character. search query, Lucene query syntax is recommended when \code{typeahead = FALSE}.}

\item{typeahead}{logical. Use typeahead for search? Default is \code{FALSE}.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of suggested accounts to follow
}
\description{
Find profiles matching search criteria
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/actor/searchActors.json}{actor/searchActors.json (2023-10-01)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/actor/searchActorsTypeahead.json}{actor/searchActorsTypeahead.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-01)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_search_actors('political science')
\dontshow{\}) # examplesIf}
}
\concept{actor}
