% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_reposts.R
\name{bs_get_reposts}
\alias{bs_get_reposts}
\title{Retrieve actors who reposted a post}
\usage{
bs_get_reposts(
  uri,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{uri}{Character, length 1. URI for post to get.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of actors
}
\description{
Retrieve actors who reposted a post
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getRepostedBy.json}{feed/getRepostedBy.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_reposts('at://did:plc:ic6zqvuw5ulmfpjiwnhsr2ns/app.bsky.feed.post/3kaa2gxjhzr2a')
\dontshow{\}) # examplesIf}
}
\concept{feed}
