% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_input}
\alias{bs_input}
\title{Create a HTML input tag configured with Bootstrap classes}
\usage{
bs_input(
  id,
  type = "text",
  value = NULL,
  placeholder = NULL,
  label = NULL,
  text = NULL,
  required = FALSE,
  div_attr = NULL,
  input_attr = c(class = "form-control"),
  label_attr = c(class = "form-label"),
  text_attr = c(class = "form-text"),
  inline = FALSE
)
}
\arguments{
\item{id}{A string, the id/name for the input, passed to the id and name attributes of the <input> tag.}

\item{type}{A string, the type of input to create, passed to the type attribute of the <input> tag.}

\item{value}{A string, the value of the input, passed to the value attribute of the <input> tag.}

\item{placeholder}{A string, passed to the placeholder attribute of the <input> tag.}

\item{label}{A string, passed to the <label> tag.}

\item{text}{A string, text or HTML to display with the input and label tags.}

\item{required}{TRUE/FALSE, if TRUE, will add the required attribute to the input tag.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, wrapping the input, label, and text.}

\item{input_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::input, but id (also name), type, value, and placeholder have their own parameters.}

\item{label_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::label.}

\item{text_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, which will display the text parameter.}

\item{inline}{TRUE/FALSE, if TRUE, adds a div and classes to display the label, input, and text in the same line.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/forms/overview/}.
}
\examples{
bs_input(
id = "example1",
label = "Example Text Input"
)
}
