% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_select}
\alias{bs_select}
\title{Create a HTML select tag configured with Bootstrap classes}
\usage{
bs_select(
  ...,
  id,
  label = NULL,
  text = NULL,
  multiple = FALSE,
  required = FALSE,
  div_attr = NULL,
  select_attr = c(class = "form-select"),
  label_attr = c(class = "form-label"),
  text_attr = c(class = "form-text")
)
}
\arguments{
\item{...}{A string or strings of HTML to pass to html5::select(), most likely a sequence of option tags.}

\item{id}{A string, the id/name for the select, passed to the id and name attributes of the <select> tag.}

\item{label}{A string, the label to use for the select, passed to html5::label().}

\item{text}{A string, text or HTML to display with the select and label tags.}

\item{multiple}{TRUE/FALSE, if TRUE, adds the "multiple" attribute to the select tag.}

\item{required}{TRUE/FALSE, if TRUE, will add the required attribute to the select tag.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, wrapping the select, label, and text.}

\item{select_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::select.}

\item{label_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::label.}

\item{text_attr}{A named list or named vector, names are attribute names and values are attribute values. Passed to the attr parameter of html5::div, which will display the text parameter.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/forms/overview/}.
}
\examples{
bs_select(
option(attr = c(value = 1), "Option One"),
option(attr = c(value = 2), "Option Two"),
id = "example1",
label = "Example Select Input"
)
}
