% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{GLM_summary}
\alias{GLM_summary}
\title{Advanced report of GLM (\code{lm} and \code{glm} models).}
\usage{
GLM_summary(model, robust = FALSE, cluster = NULL, nsmall = 3, ...)
}
\arguments{
\item{model}{A model fitted by \code{lm} or \code{glm} function.}

\item{robust}{\strong{[only for \code{lm} and \code{glm}]} \code{FALSE} (default), \code{TRUE}, or an option from \code{"HC0", "HC1", "HC2", "HC3", "HC4", "HC4m", "HC5"}.
It will add a table with heteroskedasticity-robust standard errors (aka. Huber-White standard errors).
For details, see \code{\link[sandwich]{vcovHC}} and \code{\link[jtools]{summ.lm}}.

*** \strong{\code{"HC1"}} is the default of Stata, whereas \strong{\code{"HC3"}} is the default suggested by the \code{sandwich} package.
Here we use \strong{\code{"HC1"}} as the default option.}

\item{cluster}{\strong{[only for \code{lm} and \code{glm}]} Cluster-robust standard errors are computed if cluster is set to the name of the input data's cluster variable or is a vector of clusters.
If you specify \code{cluster}, you may also specify the type of \code{robust}. If you do not specify \code{robust}, \strong{\code{"HC1"}} will be set as the default option.}

\item{nsmall}{Number of decimal places of output. Default is 3.}

\item{...}{Other parameters. You may re-define \code{formula}, \code{data}, or \code{family}.}
}
\value{
No return value.
}
\description{
Advanced report of GLM (\code{lm} and \code{glm} models).
}
\examples{
\donttest{## Example 1: OLS regression
lm=lm(Temp ~ Month + Day + Wind + Solar.R, data=airquality)
GLM_summary(lm)
GLM_summary(lm, robust="HC1")
# Stata's default is "HC1"
# R package <sandwich>'s default is "HC3"

## Example 2: Logistic regression
glm=glm(case ~ age + parity + education + spontaneous + induced,
        data=infert, family=binomial)
GLM_summary(glm)
GLM_summary(glm, robust="HC1", cluster="stratum")
}
}
\seealso{
\code{\link{HLM_summary}}, \code{\link{regress}}
}
