% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/brotli.R
\name{brotli}
\alias{brotli}
\alias{brotli_compress}
\alias{brotli_decompress}
\title{Brotli Compression}
\usage{
brotli_compress(buf, mode = c("generic", "text", "font"), quality = 11,
  log_win = 22, log_block = 0)

brotli_decompress(buf)
}
\arguments{
\item{buf}{raw vector with data to compress/decompress}

\item{mode}{which compression strategy to use}

\item{quality}{value between 0 and 11}

\item{log_win}{log of window size}

\item{log_block}{log of block size}
}
\description{
Brotli is a compression algorithm optimized for the web, in particular small text
documents.
}
\details{
Brotli decompression is at least as fast as for gzip while significantly
improving the compression ratio. The price we pay is that compression is much
slower than gzip. Brotli is therefore most effective for serving static content
such as fonts and html pages.

For binary (non-text) data, the compression ratio of Brotli usually does not beat
\code{bz2} or \code{xz (lzma)}, however decompression for these algorithms is too
slow for browsers in e.g. mobile devices.
}
\examples{
# Simple example
myfile <- file.path(R.home(), "COPYING")
x <- readBin(myfile, raw(), file.info(myfile)$size)
y <- brotli_compress(x)
stopifnot(identical(x, brotli_decompress(y)))

# Compare to other algorithms
length(x)
length(brotli_compress(x))
length(memCompress(x, "gzip"))
length(memCompress(x, "bzip2"))
length(memCompress(x, "xz"))
}
\references{
J. Alakuijala and Z. Szabadka (October 2015). \emph{Brotli Compressed
Data Format}. IETF Internet Draft \url{http://www.ietf.org/id/draft-alakuijala-brotli}.
}
\seealso{
\link{memCompress}
}

