% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{glance}
\alias{glance}
\title{Retrieve model summary dataframe if it exists.}
\usage{
glance(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\description{
Check if a \code{glance} method exits for a given object, either in
\code{broom} or in \code{broom.mixed}. If it does, return the model summary
dataframe, if not, return a \code{NULL}. In this case, you can try the
\code{broomExtra::glance_performance} function.
}
\note{
For available methods, see-
\url{https://indrajeetpatil.github.io/broomExtra/articles/available_methods.html}
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("glance")}

}

\examples{
set.seed(123)
library(lme4)

# mixed-effects models (`broom.mixed` will be used)
lmm.mod <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
broomExtra::glance(lmm.mod)

# linear model (`broom` will be used)
lm.mod <- lm(Reaction ~ Days, sleepstudy)
broomExtra::glance(lm.mod)
}
\seealso{
\code{\link{grouped_glance}}, \code{\link{glance_performance}}
}
