% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova-tidiers.R
\name{tidy.aov}
\alias{tidy.aov}
\title{Tidy a(n) aov object}
\usage{
\method{tidy}{aov}(x, ...)
}
\arguments{
\item{x}{An \code{aov} objects, such as those created by \code{\link[stats:aov]{stats::aov()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns

\item{term}{Term within the model, or "Residuals"}
\item{df}{Degrees of freedom used by this term in the model}
\item{sumsq}{Sum of squares explained by this term}
\item{meansq}{Mean of sum of squares among degrees of freedom}
\item{statistic}{F statistic}
\item{p.value}{P-value from F test}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The \code{term} column of an ANOVA table can come with leading or
trailing whitespace, which this tidying method trims.
}
\examples{

a <- aov(mpg ~ wt + qsec + disp, mtcars)
tidy(a)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:aov]{stats::aov()}}

Other anova tidiers: 
\code{\link{tidy.TukeyHSD}()},
\code{\link{tidy.anova}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
