% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_tidiers.R
\name{nls_tidiers}
\alias{nls_tidiers}
\alias{tidy.nls}
\alias{augment.nls}
\alias{glance.nls}
\title{Tidying methods for a nonlinear model}
\usage{
\method{tidy}{nls}(x, conf.int = FALSE, conf.level = 0.95, quick = FALSE,
  ...)

\method{augment}{nls}(x, data = NULL, newdata = NULL, ...)

\method{glance}{nls}(x, ...)
}
\arguments{
\item{x}{An object of class "nls"}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level of the interval, used only if
\code{conf.int=TRUE}}

\item{quick}{whether to compute a smaller and faster version, containing
only the \code{term} and \code{estimate} columns.}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed from nls (may not be successful)}

\item{newdata}{new data frame to use for predictions}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each coefficient in the model,
with five columns:
  \item{term}{The term in the nonlinear model being estimated and tested}
  \item{estimate}{The estimated coefficient}
  \item{std.error}{The standard error from the linear model}
  \item{statistic}{t-statistic}
  \item{p.value}{two-sided p-value}

\code{augment} returns one row for each original observation,
with two columns added:
  \item{.fitted}{Fitted values of model}
  \item{.resid}{Residuals}

If \code{newdata} is provided, these are computed on based on predictions
of the new data.

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{isConv}{whether the fit successfully converged}
  \item{finTol}{the achieved convergence tolerance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
These methods tidy the coefficients of a nonlinear model into a summary,
augment the original data with information on the fitted values and residuals,
and construct a one-row glance of the model's statistics.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

n <- nls(mpg ~ k * e ^ wt, data = mtcars, start = list(k = 1, e = 2))

tidy(n)
augment(n)
glance(n)

library(ggplot2)
ggplot(augment(n), aes(wt, mpg)) + geom_point() + geom_line(aes(y = .fitted))

# augment on new data
newdata <- head(mtcars)
newdata$wt <- newdata$wt + 1
augment(n, newdata = newdata)

}
\seealso{
\link{na.action}

\code{\link{nls}} and \code{\link{summary.nls}}
}
