% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_tidiers.R
\name{list_tidiers}
\alias{glance.list}
\alias{list_tidiers}
\alias{tidy.list}
\title{Tidiers for return values from functions that aren't S3 objects}
\usage{
\method{tidy}{list}(x, ...)

\method{glance}{list}(x, ...)
}
\arguments{
\item{x}{list object}

\item{...}{extra arguments, passed to the tidying function}
}
\description{
This method handles the return values of functions that return lists
rather than S3 objects, such as \code{optim}, \code{svd}, or
\code{\link[akima]{interp}}, and therefore cannot be handled by
S3 dispatch.
}
\details{
Those tiders themselves are implemented as functions of the
form tidy_<function> or glance_<function> that are not exported.
}
\seealso{
\link{optim_tidiers}, \link{xyz_tidiers},
\link{svd_tidiers}, \link{orcutt_tidiers}
}

