% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{dotplot}
\alias{dotplot}
\title{Dot chart with a gray background}
\usage{
dotplot(group, y, jiggle, rotate = FALSE, ...)
}
\arguments{
\item{group}{Categorical coordinates for the plot}

\item{y}{Coordinates of points in the plot}

\item{jiggle}{Vector of amounts to jiggle the points horizontally,
or a character string (\code{"fixed"} or \code{"random"})
indicating the jiggling method; see \code{\link{jiggle}}.}

\item{rotate}{If TRUE, have group as y-axis; default (FALSE) has
group on x-axis.}

\item{...}{Optional graphics arguments}
}
\value{
None.
}
\description{
Like the \code{\link{grayplot}} function, but with one axis assumed to be categorical.
}
\details{
Calls \code{\link{grayplot}} with special choices of
graphics parameters for the case of categorical x.
}
\examples{
\dontshow{set.seed(97536917)}
x <- rnorm(40, c(1,3))
g <- rep(c("A", "B"), 20)
dotplot(g, x)
dotplot(g, x, "random")
dotplot(g, x, runif(length(g), -0.25, 0.25))

}
\seealso{
\code{\link{grayplot}},
}
\keyword{graphics}

