% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pastedot.R
\name{paste00}
\alias{paste..}
\alias{paste.0}
\alias{paste0.}
\alias{paste00}
\title{paste with null or dot as separator and with collapse}
\usage{
paste00(...)
}
\arguments{
\item{...}{Passed to paste.}
}
\value{
A character string or vector of character strings.
}
\description{
Call \code{\link[base]{paste}} with \code{sep="."} or \code{sep=""}
  and \code{collapse=""} or \code{collapse="."}.
}
\details{
There's not much to these functions.
  \code{paste00(\dots)} is like \code{paste(\dots, sep="", collapse="")}
  \code{paste..(\dots)} is like \code{paste(\dots, sep=".", collapse=".")}
  \code{paste0.(\dots)} is like \code{paste(\dots, sep="", collapse=".")}
  \code{paste.0(\dots)} is like \code{paste(\dots, sep=".", collapse="")}
}
\examples{
x <- c(3, 4)
y <- c(5, 6)
paste00(x, y)
paste..(x, y)
paste0.(x, y)
paste.0(x, y)
}
\seealso{
\code{\link[base]{paste}},
  \code{\link[base]{paste0}},
  \code{\link{paste.}}
}
\keyword{character}

