% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broadcaster.R
\name{broadcaster}
\alias{broadcaster}
\alias{broadcaster<-}
\title{Check or Set if an Array is a Broadcaster}
\usage{
broadcaster(x)

broadcaster(x) <- value
}
\arguments{
\item{x}{object to check or set. \cr
Only S3 vectors and arrays are supported, and only up to 16 dimensions.}

\item{value}{set to \code{TRUE} to make an array a broadcaster,
or \code{FALSE} to remove the broadcaster class attribute from an array.}
}
\value{
For \code{broadcaster()}: \cr
\code{TRUE} if an array or vector is a broadcaster, or \code{FALSE} if it is not. \cr
\cr
For \verb{broadcaster()<-}: \cr
Returns nothing,
but sets (if right hand side is \code{TRUE})
or removes (if right hand side is \code{FALSE})
the "broadcaster" class attribute. \cr \cr
}
\description{
\code{broadcaster()} checks if an array has the "broadcaster" attribute. \cr
\verb{broadcaster()<-} sets or un-sets the class attribute "broadcaster" on an array. \cr
\cr
The \code{broadcaster} class attribute exists purely to overload the
arithmetic, Boolean, bit-wise, and relational infix operators,
to support broadcasting. \cr
This makes mathematical expressions with multiple variables,
where precedence may be important,
far more convenient. \cr
Like in the following calculation: \cr
\code{x / (y + z)} \cr
\cr
See \link{broadcast_operators} for more information. \cr
}
\examples{

# maths ====

x <- 1:10
broadcaster(x) <- TRUE

y <- 1:10
broadcaster(y) <- TRUE

x + y / x
x + 1 # mathematically equivalent to the above, since x == y
(x + y) / x
2 * x/x # mathematically equivalent to the above, since x == y

dim(x) <- c(10, 1)
dim(y) <- c(1, 10)

x + y / x
(x + y) / x

(x + y) * x


# relational operators ====
x <- 1:10
y <- array(1:10, c(1, 10))
broadcaster(x) <- TRUE
broadcaster(y) <- TRUE

x == y
x != y
x < y
x > y
x <= y
x >= y

}
