% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorsense.R
\name{create_priorsense_data.brmsfit}
\alias{create_priorsense_data.brmsfit}
\title{Prior sensitivity: Create priorsense data}
\usage{
create_priorsense_data.brmsfit(x, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object.}

\item{...}{Currently unused.}
}
\value{
A \code{priorsense_data} object to be used in conjunction
with the \pkg{priorsense} package.
}
\description{
The \code{create_priorsense_data.brmsfit} method can be used to
create the data structure needed by the \pkg{priorsense} package
for performing power-scaling sensitivity analysis. This method is
called automatically when performing powerscaling via
\code{\link[priorsense:powerscale]{powerscale}} or other related
functions, so you will rarely need to call it manually yourself.
}
\examples{
\dontrun{
# fit a model with non-uniform priors
fit <- brm(rating ~ treat + period + carry,
           data = inhaler, family = sratio(),
           prior = set_prior("normal(0, 0.5)"))
summary(fit)

# The following code requires the 'priorsense' package to be installed:
library(priorsense)

# perform power-scaling of the prior
powerscale(fit, alpha = 1.5, component = "prior")

# perform power-scaling sensitivity checks
powerscale_sensitivity(fit)

# create power-scaling sensitivity plots (for one variable)
powerscale_plot_dens(fit, variable = "b_treat")
}

}
