% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{cov_fixed}
\alias{cor_fixed}
\alias{cov_fixed}
\title{Fixed user-defined covariance matrices}
\usage{
cov_fixed(V)
}
\arguments{
\item{V}{Known covariance matrix of the response variable.
If a vector is passed, it will be used as diagonal entries 
(variances) and covariances will be set to zero.}
}
\value{
An object of class \code{cov_fixed}.
}
\description{
Define a fixed covariance matrix of the response variable
for instance to model multivariate effect sizes in meta-analysis.
}
\examples{
\dontrun{
dat <- data.frame(y = rnorm(3))
V <- cbind(c(0.5, 0.3, 0.2), c(0.3, 1, 0.1), c(0.2, 0.1, 0.2))
fit <- brm(y~1, data = dat, autocor = cov_fixed(V))
}

}

