% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{ranef.brmsfit}
\alias{ranef}
\alias{ranef.brmsfit}
\title{Extract Random Effects Estimates}
\usage{
\method{ranef}{brmsfit}(object, estimate = "mean", var = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{estimate}{The point estimate to be calculated 
for the random effects, either "mean" or "median".}

\item{var}{logical; indicating if the covariance matrix 
for each random effects should be computed.}

\item{...}{Further arguments to be passed to the function 
specified in \code{estimate}}
}
\value{
A list of matrices (one per grouping factor), 
 with factor levels as row names and 
 random effects as column names
}
\description{
Extract the random effects of each level from \code{brmsfit} object.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit), 
             data = epilepsy, family = "poisson", chains = 1)
## random effects means with corresponding covariances
rf <- ranef(fit, var = TRUE)
attr(rf, "var")
## random effects medians
ranef(fit, estimate = "median")                                                        
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

