% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{db_workspace_delete}
\alias{db_workspace_delete}
\title{Delete Object/Directory (Workspaces)}
\usage{
db_workspace_delete(
  path,
  recursive = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{Absolute path of the notebook or directory.}

\item{recursive}{Flag that specifies whether to delete the object
recursively. \code{False} by default.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Delete Object/Directory (Workspaces)
}
\details{
Delete an object or a directory (and optionally recursively deletes all
objects in the directory). If path does not exist, this call returns an error
\code{RESOURCE_DOES_NOT_EXIST}. If path is a non-empty directory and recursive is
set to false, this call returns an error \code{DIRECTORY_NOT_EMPTY.}

Object deletion cannot be undone and deleting a directory recursively is not
atomic.
}
\seealso{
Other Workspace API: 
\code{\link{db_workspace_export}()},
\code{\link{db_workspace_get_status}()},
\code{\link{db_workspace_import}()},
\code{\link{db_workspace_list}()},
\code{\link{db_workspace_mkdirs}()}
}
\concept{Workspace API}
