% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdyplFit.R, R/zzz_conventions.R
\name{mdyplControl}
\alias{mdyplControl}
\alias{mdypl_control}
\title{Auxiliary function for \code{\link[=glm]{glm()}} fitting using the \code{\link[=brglmFit]{brglmFit()}}
method.}
\usage{
mdyplControl(alpha = NULL, epsilon = 1e-08, maxit = 25, trace = FALSE)

mdypl_control(alpha = NULL, epsilon = 1e-08, maxit = 25, trace = FALSE)
}
\arguments{
\item{alpha}{the shrinkage parameter (in \verb{[0, 1]}) in the
Diaconis-Ylvisaker prior penalty. Default is \code{NULL}, which
results in \code{alpha = m / (m + p)}, where \code{m} is the sum of the
binomial totals and \code{p} is the number of model
parameters. Setting \code{alpha = 1} corresponds to using maximum
likelihood, i.e. no penalization. See Details.}

\item{epsilon}{positive convergence tolerance epsilon. Default is
\code{1e-08}.}

\item{maxit}{integer giving the maximal number of iterations
allowed. Default is \code{25}.}

\item{trace}{logical indicating if output should be produced for
each iteration. Default is \code{FALSE}.}
}
\value{
A list with components named as the arguments.
}
\description{
Typically only used internally by \code{\link[=brglmFit]{brglmFit()}}, but may be used to
construct a \code{control} argument.
}
\details{
Internally, \code{\link[=mdyplFit]{mdyplFit()}} uses \code{\link[stats:glm]{stats::glm.fit()}} to fit a logistic
regression model on responses \code{alpha * y + (1 - alpha) / 2}, where
\code{y} are the original binomial responses scaled by the binomial
totals. \code{epsilon}, \code{maxit} and \code{trace} control the
\code{\link[stats:glm]{stats::glm.fit()}} call; see \code{\link[stats:glm.control]{stats::glm.control()}}.
}
\seealso{
\code{\link[=mdyplFit]{mdyplFit()}}, \code{\link[=glm.control]{glm.control()}}
}
\author{
Ioannis Kosmidis \verb{[aut, cre]} \email{ioannis.kosmidis@warwick.ac.uk}
}
