% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_fitted_line_2d}
\alias{br_show_fitted_line_2d}
\title{Show 2d fitted regression line with \code{visreg} interface}
\usage{
br_show_fitted_line_2d(breg, idx = 1, ...)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Length-1 vector. Index or name (focal variable) of the model.
This is different from \code{idx} in \link{br_show_forest_ggstats}, only one model is supported
to visualized here, so only length-1 vector is supported as \code{idx}.}

\item{...}{Arguments passing to \code{\link[visreg:visreg2d]{visreg::visreg2d()}} excepts \code{fit} and \code{data}.}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Similar to \code{\link[=br_show_fitted_line]{br_show_fitted_line()}}, but visualize how \emph{two variables} interact to affect the response in regression models.
}
\examples{
if (rlang::is_installed("visreg")) {
  m <- br_pipeline(mtcars,
    y = "mpg",
    x = colnames(mtcars)[2:4],
    x2 = "vs",
    method = "gaussian"
  )

  br_show_fitted_line_2d(m, xvar = "cyl", yvar = "mpg")
}

}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
