% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbs_bic_cpt.R
\name{wbs.bic.cpt}
\alias{wbs.bic.cpt}
\title{Multiple change-point detection in the mean of a vector using the WBS method, with the number of change-points chosen by BIC}
\usage{
wbs.bic.cpt(x, M = 20000, Kmax = ceiling(length(x)/5))
}
\arguments{
\item{x}{A vector containing the data in which you wish to find change-points.}

\item{M}{The number of randomly selected sub-segments of the data on which to build
the CUSUM statistics in the Wild Binary Segmentation algorithm; generally, the larger
the value of M, the more accurate but slower the algorithm - but see the remarks below
about the BIC penalty.}

\item{Kmax}{The maximum number of change-points that can be detected.}
}
\value{
A list with the following components:
\item{est}{The estimated piecewise-constant mean of \code{x}.}
\item{no.of.cpt}{The estimated number of change-points in the piecewise-constant mean of \code{x}.}
\item{cpt}{The estimated locations of change-points in the piecewise-contant mean of \code{x} (these
are the final indices \emph{before} the location of each change-point).}
}
\description{
This function estimates the number and locations of change-points in the 
piecewise-constant mean of the noisy input vector, using the Wild Binary Segmentation
method (see Details for the relevant literature reference). The number of change-points
is chosen via the Bayesian Information Criterion. The constant means between each pair 
of neighbouring change-points are also estimated. The method works best when the noise in the 
input vector is independent and identically distributed Gaussian, and when the number
change-points is small.
}
\details{
The BIC penalty is unsuitable as a model selection tool in long signals
with frequent change-points; if you need a more versatile function that works well 
regardless of the number of change-points, try \code{\link{segment.mean}} (for a
default recommended estimation technique), \code{\link{wbs.thresh.cpt}},
\code{\link{wbs.cpt}} (if you require an (Adaptive) WBS-based technique), \code{\link{tguh.cpt}}
(if you require a TGUH-based technique), or \code{\link{hybrid.cpt}}
(to use a hybrid between TGUH and Adaptive WBS). If you are unsure where to start, try
\code{\link{segment.mean}}. (If you know how many change-points you wish to detect,
try \code{\link{wbs.K.cpt}}.)

The change-point detection algorithm used in \code{wbs.bic.cpt} is the 
Wild Binary Segmentaton method as described in "Wild Binary Segmentation for multiple 
change-point detection", P. Fryzlewicz (2014), Annals of Statistics, 42, 2243-2281.
}
\examples{
teeth <- rep(rep(0:1, each=5), 20)
teeth.noisy <- teeth + rnorm(200)/5
teeth.cleaned <- wbs.bic.cpt(teeth.noisy)
ts.plot(teeth.cleaned$est)
teeth.cleaned$no.of.cpt
teeth.cleaned$cpt
}
\seealso{
\code{\link{segment.mean}}, \code{\link{wbs.thresh.cpt}},
\code{\link{wbs.cpt}}, \code{\link{tguh.cpt}}, \code{\link{hybrid.cpt}}, \code{\link{wbs.K.cpt}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
