% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{plot.brainGraphList}
\alias{plot.brainGraphList}
\title{Plot a brainGraphList and write to PDF}
\usage{
\method{plot}{brainGraphList}(x, plane, hemi, filename.base,
  diffs = FALSE, ...)
}
\arguments{
\item{x}{A \code{brainGraphList} object}

\item{plane}{Character string indicating which orientation to plot.
Default: \code{'axial'}}

\item{hemi}{Character string indicating which hemisphere to plot. Default:
\code{'both'}}

\item{filename.base}{Character string specifying the base of the filename}

\item{diffs}{Logical, indicating whether edge differences should be
highlighted. Default: \code{FALSE}}

\item{...}{Other parameters (passed to \code{\link{plot.brainGraph}})}
}
\description{
The \code{plot} method will write a PDF file containing plots for all graphs
in the given object.
}
\details{
You can choose to highlight edge differences between subsequent list
elements; in this case, new/different edges are colored pink. This is useful
mostly for a list of group-level graphs.
}
\seealso{
Other Plotting functions: \code{\link{Plotting GLM graphs}},
  \code{\link{plot.brainGraph}},
  \code{\link{plot_brainGraph_multi}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Plotting functions}
