% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{brainGraph-methods}
\alias{brainGraph-methods}
\alias{groups.brainGraphList}
\alias{groups.corr_mats}
\alias{region.names}
\alias{region.names.data.table}
\alias{nregions}
\title{brainGraph generic methods}
\usage{
\method{groups}{brainGraphList}(x)

\method{groups}{corr_mats}(x)

region.names(object)

\method{region.names}{data.table}(object)

nregions(object)
}
\arguments{
\item{x, object}{An object}
}
\description{
These functions are S3 \emph{generics} for various \code{brainGraph}-defined
objects.

\code{groups} returns the \dQuote{Group} graph attribute for each graph or
observation in the object.

\code{region.names} is a generic method for extracting region names from
various \code{brainGraph} objects. These are generally convenience functions.

\code{nregions} is a generic method for extracting the number of regions from
various \code{brainGraph} objects.
}
\details{
For a \code{data.table}, \code{region.names} assumes that it contains a
\emph{factor} column named \code{region}.
}
