% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtpc.R
\name{mtpc}
\alias{mtpc}
\alias{summary.mtpc}
\title{Multi-threshold permutation correction}
\usage{
mtpc(g.list, thresholds, covars, measure, con.mat, con.type = c("t", "f"),
  con.name = NULL, level = c("vertex", "graph"), clust.size = 3L,
  N = 500L, perms = NULL, alpha = 0.05, res.glm = NULL, long = TRUE,
  ...)

\method{summary}{mtpc}(object, contrast = NULL, digits = max(3L,
  getOption("digits") - 2L), print.head = TRUE, ...)
}
\arguments{
\item{g.list}{A list of lists of \code{igraph} graph objects for all
thresholds and subjects}

\item{thresholds}{Numeric vector of the thresholds applied to the raw
connectivity matrices.}

\item{covars}{A \code{data.table} of covariates}

\item{measure}{Character string of the graph measure of interest}

\item{con.mat}{Numeric matrix specifying the contrast(s) of interest; if
only one contrast is desired, you can supply a vector}

\item{con.type}{Character string; either \code{'t'} or \code{'f'} (for t or
F-statistics). Default: \code{'t'}}

\item{con.name}{Character vector of the contrast name(s); if \code{con.mat}
has row names, those will be used for reporting results (default:
\code{NULL})}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{clust.size}{Integer indicating the size of "clusters" (i.e.,
consecutive thresholds for which the observed statistic exceeds the null)
(default: \code{3L})}

\item{N}{Integer; number of permutations to create (default: 5e3)}

\item{perms}{Matrix of permutations, if you would like to provide your own
(default: \code{NULL})}

\item{alpha}{Numeric; the significance level (default: 0.05)}

\item{res.glm}{A list of \code{bg_GLM} objects, as output by a previous run
of \code{mtpc}. Useful if you want to change the cluster size without
re-running all of the GLM's and permutations (default: \code{NULL})}

\item{long}{Logical indicating whether or not to return all permutation
results (default: \code{FALSE})}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM}} and/or
\code{\link{brainGraph_GLM_design}}}

\item{object}{A \code{mtpc} object}

\item{contrast}{Integer specifying the contrast to summarize; defaults to
showing results for all contrasts}

\item{digits}{Integer specifying the number of digits to display for p-values}

\item{print.head}{Logical indicating whether or not to print only the first
and last 5 rows of the statistics tables (default: \code{TRUE})}
}
\value{
An object of class \code{mtpc} with some input arguments plus the
  following elements:
  \item{res.glm}{List with length equal to the number of thresholds; each
    list element is the output from \code{\link{brainGraph_GLM}}}
  \item{DT}{A \code{data.table} for all thresholds, combined from the outputs
    of \code{\link{brainGraph_GLM}}}
  \item{stats}{A data.table containing \code{S.mtpc} (the max. observed
    statistic), \code{tau.mtpc} (the threshold of the max. observed
    statistic), \code{S.crit} (the critical statistic value), and
    \code{A.crit} (the critical AUC)}
  \item{null.dist}{Numeric matrix with \code{N} rows and number of columns
    equal to the number of thresholds. Each element is the maximum statistic
    for that permutation and threshold.}
  \item{perm.order}{Numeric matrix; the permutation set applied for all
    thresholds (each row is a separate permutation)}
}
\description{
Applies the \emph{multi-threshold permutation correction (MTPC)} method to
perform inference in graph theory analyses of brain MRI data.

Print a summary of MTPC results
}
\details{
This is a multi-step procedure: (steps 3-4 are the time-consuming steps)
\enumerate{
  \item Apply thresholds \eqn{\tau} to the networks, and compute network
    metrics for all networks and thresholds. (already done beforehand)
  \item Compute test statistics \eqn{S_{obs}} for each threshold. (done by
    \code{\link{brainGraph_GLM}})
  \item Permute group assignments and compute test statistics for each
    permutation and threshold. (done by \code{\link{brainGraph_GLM}})
  \item Build a null distribution of the maximum statistic across thresholds
    (and across brain regions) for each permutation. (done by
    \code{\link{brainGraph_GLM}})
  \item Determine the critical value, \eqn{S_{crit}} from the null
    distribution of maximum statistics.
  \item Identify clusters where \eqn{S_{obs} > S_{crit}} and compute the AUC
    for these clusters (denoted \eqn{A_{MTPC}}).
  \item Compute a critical AUC (\eqn{A_{crit}}) from the mean of the
    supra-critical AUC's for the permuted tests.
  \item Reject \eqn{H_0} if \eqn{A_{MTPC} > A_{crit}}.
}
}
\examples{
\dontrun{
diffs.mtpc <- mtpc(g.list=g.norm, thresholds=thresholds, N=N,
     covars=covars.dti, measure='E.nodal.wt', coding='effects',
     con.mat=c(0, 0, 0, 0, -2), alt='greater',
     binarize=c('Sex', 'Scanner'), con.name='Group 1 > Group 2')
sig.regions <- diffs.mtpc$DT[A.mtpc > A.crit]
}
}
\references{
Drakesmith M, Caeyenberghs K, Dutt A, Lewis G, David AS, Jones
  DK (2015). \emph{Overcoming the effects of false positives and threshold
  bias in graph theoretical analyses of neuroimaging data.} NeuroImage,
  118:313-333.
}
\seealso{
Other Group analysis functions: \code{\link{IndividualContributions}},
  \code{\link{NBS}}, \code{\link{brainGraph_GLM}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_mediate}},
  \code{\link{brainGraph_permute}}

Other GLM functions: \code{\link{GLMfit}},
  \code{\link{brainGraph_GLM_design}},
  \code{\link{brainGraph_GLM}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
