% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_random_graphs.R
\name{analysis_random_graphs}
\alias{analysis_random_graphs}
\title{Perform an analysis with random graphs for brain MRI data}
\usage{
analysis_random_graphs(g, N, covars, savedir = ".", ...)
}
\arguments{
\item{g}{A list object containing all graphs (may be nested)}

\item{N}{Integer specifying number of random graphs to generate per
individual graph}

\item{covars}{Data table of covariates (used for Group and subject names)}

\item{savedir}{Character string specifying the directory in which to save the
generated graphs (default: current working directory)}

\item{...}{Other arguments passed to \code{\link{sim.rand.graph.par}} (e.g.
\emph{clustering=F})}
}
\value{
A list containing:
\item{rich}{A list object containing normalized rich-club coefficients and
  p-values}
\item{small}{A data table with small-world parameters}
\item{rand}{A data table with some global graph measures for all random
  graphs generated}
}
\description{
This function is not quite a "proper" function. It performs the steps needed
for doing typical graph theory analyses with brain MRI data if you need to
generate equivalent random graphs. This includes calculating \emph{small
world} parameters and normalized \emph{rich club} coefficients.
}
\details{
First, a number of random graphs are generated for each group and
density/threshold (and subject if you have subject-specific graphs). These
graphs are all written to disk in a location you specify. All of these are
read back into \code{R} and combined into large lists; these large lists are
also written to disk (in a sub-directory named \code{ALL}), so you can delete
the individual \code{.rds} files afterwards. Once all of the random graphs
have been generated, the \emph{small world} parameters are calculated, along
with values for a few global graph measures that may be of interest.
Additionally, the \emph{normalized rich club coefficients} and associated
p-values will be calculated.
}
\examples{
\dontrun{
rand_all <- random_graph_analysis(g.norm, 1e2, covars.dti,
  savedir='~/dti/rand', clustering=F)
}
}
\seealso{
\code{\link{sim.rand.graph.par}, \link{small.world},
  \link{rich_club_norm}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
