% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{summary.bqrorOR1}
\alias{summary.bqrorOR1}
\title{Extractor function for summary}
\usage{
\method{summary}{bqrorOR1}(object, digits, ...)
}
\arguments{
\item{object}{bqrorOR1 object from which the summary is extracted.}

\item{digits}{controls the number of digits after the decimal.}

\item{...}{extra arguments}
}
\value{
the summarized information object
}
\description{
This function extracts the summary from the bqrorOR1 object
}
\details{
This function is an extractor function for the summary
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
k <- dim(xMat)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
output <- quantregOR1(y = y, x = xMat, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, accutoff = 0.5, maxlags = 400, verbose = FALSE)
summary(output, 4)

 #            Post Mean  Post Std   Upper Credible Lower Credible Inef Factor
 # beta_1       -2.6202   0.3588        -2.0560        -3.3243       1.1008
 # beta_2        3.1670   0.5894         4.1713         2.1423       3.0024
 # beta_3        4.2800   0.9141         5.7142         2.8625       2.8534
 # delta_1       0.2188   0.4043         0.6541        -0.4384       3.6507
 # delta_2       0.4567   0.3055         0.7518        -0.2234       3.1784

}
