% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{drawlatentOR2}
\alias{drawlatentOR2}
\title{Samples latent variable z in the OR2 model}
\usage{
drawlatentOR2(y, x, beta, sigma, nu, theta, tau2, gammacp)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{beta}{Gibbs draw of \eqn{\beta}, a column vector of size \eqn{(k x 1)}.}

\item{sigma}{\eqn{\sigma}, a scalar value.}

\item{nu}{modified latent weight, column vector of size \eqn{(n x 1)}.}

\item{theta}{(1-2p)/(p(1-p)).}

\item{tau2}{2/(p(1-p)).}

\item{gammacp}{row vector of cut-points including -Inf and Inf.}
}
\value{
latent variable z of size \eqn{(n x 1)} from a univariate truncated distribution.
}
\description{
This function samples the latent variable z from a univariate truncated
normal distribution in the OR2 model (ordinal quantile model with exactly 3 outcomes).
}
\details{
This function samples the latent variable z from a univariate truncated normal
distribution.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
beta <- c(1.810504, 1.850332, 6.181163)
sigma <- 0.9684741
n <- dim(xMat)[1]
nu <- array(5 * rep(1,n), dim = c(n, 1))
theta <- 2.6667
tau2 <- 10.6667
gammacp <- c(-Inf, 0, 3, Inf)
output <- drawlatentOR2(y, xMat, beta, sigma, nu,
theta, tau2, gammacp)

# output
#   1.257096 10.46297 4.138694
#   28.06432 4.179275 19.21582
#   11.17549 13.79059 28.3650 .. soon

}
\references{
Albert, J., and Chib, S. (1993). “Bayesian Analysis of Binary and Polychotomous
Response Data.” Journal of the American Statistical
Association, 88(422): 669–679. DOI: 10.1080/01621459.1993.10476321

Devroye, L. (2014). “Random variate generation for the generalized inverse Gaussian
distribution.” Statistics and Computing, 24(2): 239–246. DOI: 10.1007/s11222-012-9367-z
}
\seealso{
Gibbs sampling, truncated normal distribution,
\link[truncnorm]{rtruncnorm}
}
