% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{alcdfstdg3}
\alias{alcdfstdg3}
\title{CDF of a standard Asymmetric Laplace Distribution}
\usage{
alcdfstdg3(x, p)
}
\arguments{
\item{x}{scalar value.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns the probability value from the CDF of an asymmetric
Laplace distribution.
}
\description{
This function computes the CDF of a standard asymmetric
Laplace distribution i.e. AL\eqn{(0, 1 ,p)}.
}
\details{
Computes the CDF of a standard asymmetric Laplace distribution.
\deqn{CDF(x) = F(x) = P(X \le x)} where X is a
random variable that follows AL\eqn{(0, 1 ,p)}.
}
\examples{
set.seed(101)
x <-  -0.5428573
p <- 0.25
ans <- alcdfstdg3(x, p)

# ans
#   0.1663873

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

 Koenker, R. and Machado, J. (1999). “Goodness  of  Fit  and  Related
 Inference  Processes  for  Quantile Regression.”
 Journal of American Statistics Association, 94(3): 1296-1309.

 Keming, Y. and Zhang, J. (2005). “A Three-Parameter Asymmetric
 Laplace Distribution.” Communications in Statistics - Theory and Methods, 34(9):
 1867-1879.
}
\seealso{
asymmetric Laplace distribution
}
