% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdselect.R
\name{threshold.select}
\alias{threshold.select}
\title{Estimate of the overall Jaccard stability}
\arguments{
\item{data.input}{a \code{data.frame} of the data set where the rows are observations and columns are covariates}

\item{threshold.seq}{a \code{numeric} sequence of candidate threshold}

\item{B}{number of bootstrap re-samplings}

\item{cor.method}{the correlation method applied to the data set,three method are available: \code{"pearson", "kendall", "spearman"}.}

\item{large.size}{the smallest set of modules, the \code{large.size=0} is recommended to use right now.}

\item{PermuNo}{number of random graphs for the estimation of expected stability}

\item{no_cores}{a \code{interger} number of CPU cores on the current host.}
}
\value{
\describe{
\item{\code{stabilityresult}}{a \code{list} of result for nodes-wise stability}
\item{\code{modularityresult}}{a \code{list} of modularity information with each candidate threshold}
\item{\code{jaccardresult}}{a \code{list} estimated unconditional observed stability and 
     the estimates of expected stability under the nul}
\item{\code{originalinformation}}{a \code{list} information for original data,
      igraph object and adjacency matrix constructed with each candidate threshold}
\item{\code{threshold.seq}}{a \code{list} of candicate threshold given to the function}
}
}
\description{
Estimate of the overall Jaccard stability
}
\details{
\code{threshold.select} is used to estimate of the overall Jaccard stability from 
a sequence of given threshold candidates, \code{threshold.seq}.
}
\examples{
\dontrun{
set.seed(1)
data(wine)
x0 <- wine[1:50,]

mytest<-threshold.select(data.input=x0,threshold.seq=seq(0.5,0.8,by=0.05), B=20, 
cor.method='pearson',large.size=0,
PermuNo = 10,
scheme_2 = FALSE)
}
}
\references{
A framework for stability-based module detection in correlation graphs.
Mingmei Tian,Rachael Hageman Blair,Lina Mu, Matthew Bonner, Richard Browne and Han Yu.
}
\author{
Mingmei Tian
}
