% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistributionsToCIs.R
\name{getExpFromCI}
\alias{getExpFromCI}
\title{Find the best-fit exponential distribution for a given confidence interval.}
\usage{
getExpFromCI(qLow, qUpp, alpha = 0.05, initPars = 1, maxiter = 1000)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A single number giving the initial rate parameter value to start the optimisation; defaults to 1.}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A list with 5 elements:
\item{r}{The sampling function.}
\item{d}{The density function.}
\item{p}{The distribution function.}
\item{q}{The quantile function.}
\item{pars}{A single number giving the rate parameter for the best-fit exponential distribution (\code{rate} as in \code{\link{rexp}}, \code{\link{dexp}}, \code{\link{pexp}}, \code{\link{qexp}}).}
}
\description{
Finds the best-fit exponential distribution for a given confidence interval; returns the corresponding density, distribution, quantile and sampling functions.
}
\examples{
n<-getExpFromCI(qLow=0.01,qUpp=1.75)
print(n$pars) # the fitted rate parameter value
n$r(10) # 10 random values from the fitted exponential distribution
n$d(2) # the probability density at x=2 for the exponential distribution
n$p(1.5) # the cumulative density at x=1.5 for the fitted exponential distribution
n$q(c(0.25,0.5,0.75)) # the 25th, 50th (median) and 75th percentiles of the fitted distribution
x<-seq(0,5,length=1e3)
y<-n$d(x)
plot(x,y,type="l",xlab="",ylab="density") # density plot for the fitted exponential distribution

}
\seealso{
\code{\link{identifyExpPars}}, \code{\link{optim}}, \code{\link{dexp}}
}
